

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

float		LOD_firstLevel;
float		LOD_nextLevel;
float		LOD_changePoint;

float3		eyePosition;
float2		sectionPosition;
float		waterHeight;

///////////////////////////////////////////////////////////

struct VS_INPUT 
{
	float4	position	:	POSITION;
	float2	uv			:	TEXCOORD0;
	float	height		:	TEXCOORD1;
	float	nextHeight	:	TEXCOORD2;
};
	
///////////////////////////////////////////////////////////

struct VS_OUTPUT 
{
	float4	position	:	POSITION;
	float	height		:	TEXCOORD0;
	float2	uv			:	TEXCOORD1;
};

///////////////////////////////////////////////////////////

VS_OUTPUT vs_water_3d_edge( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = float4(input.position.x + sectionPosition.x,input.height,input.position.z + sectionPosition.y,1);
	
	float nLodDistance = sqrt((eyePosition.x-output.position.x)*(eyePosition.x-output.position.x) + (eyePosition.y-output.position.y)*(eyePosition.y-output.position.y) + (eyePosition.z-output.position.z)*(eyePosition.z-output.position.z));
	if (nLodDistance >= LOD_changePoint)
		output.position.y = lerp( input.height, input.nextHeight, clamp((nLodDistance - LOD_changePoint) / ((LOD_nextLevel - LOD_firstLevel) * 0.25f),0,1) );

	output.height = output.position.y;

	output.position.y = waterHeight + 10.0f;
	output.uv = (float2( output.position.x, output.position.z) / 102400.0f * 25.0f);
	output.position = mul(output.position, shader_transform_viewProj);


	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_noise = sampler_state
{
	Texture = (shader_texture_0);
	AddressU=Wrap;
	AddressV=Wrap;
};

sampler sampler_colour_edge = sampler_state
{
	Texture = (shader_texture_1);
	AddressU=Clamp;
	AddressV=Clamp;
};

////////////////////////////////////////////////////////////

float4 ps_water_3d_edge( VS_OUTPUT input ) : COLOR0
{
	float nWaterUv = saturate((waterHeight - input.height) / 250.0f);

	nWaterUv += nWaterUv > 0.5f ? tex2D(sampler_noise, input.uv).r * 0.1f : 0.0f;

	return float4(1,1,1,tex2D(sampler_colour_edge, float2(0.0f,nWaterUv)).r );
}


technique water_3d_edge_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_water_3d_edge();	
		PixelShader = compile ps_2_0 ps_water_3d_edge();	
	}
}
